/*
 * Created on Jun 25, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.dataaccess.jpa;

import java.util.HashMap;
import java.util.Map;

import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;

import org.eclipse.core.runtime.IPath;

import com.tandbergtv.watchpoint.studio.ui.WatchPointStudioPlugin;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;

/**
 * Singleton Class that maintains the Context required to use JPA.
 * 
 * @author Vijay Silva
 */
public class JPAContext
{
	/**
	 * The Name of the Persistence Units used by this plugin.
	 */
	public static final String FILESYSTEM_APPLICATION_PERSISTENCE_UNIT = "com.tandbergtv.watchpoint.studio";
	
	private static final String CONNECTION_URL_PROTOCOL = "jdbc:derby:";
	private static final String CONNECTION_URL_DATABASE_FOLDER = "database";
	private static final String CONNECTION_URL_OPTIONS = ";create=true";
	
	// The Singleton instance of the Context
	private static final JPAContext CONTEXT = new JPAContext();

	// The Entity Manager Factory used for the filesystem persisted objects
	private EntityManagerFactory entityManagerFactory = null;

	// Flag to indicate that the Context is correctly initialized
	private boolean initialized = false;

	/*
	 * Cannot instantiate
	 */
	private JPAContext()
	{
	}

	/**
	 * Get the JPAContext used by the application.
	 * 
	 * @return The JPAContext to use.
	 */
	public static synchronized JPAContext getContext()
	{
		return CONTEXT;
	}

	/**
	 * Initialize the Context State.
	 */
	@SuppressWarnings({ "rawtypes", "unchecked" })
	public synchronized void initializeContext()
	{
		// Check if already initialized
		if (this.initialized)
			return;

		/* Stores the database in the plugin state location - usually: workspace_location/.metadata/.plugins/org.jbpm.gd.jpdl
		 * The final folder should be: workspace_location/.metadata/.plugins/org.jbpm.gd.jpdl/database$STUDIO_VERSION */
		Map properties = new HashMap();
		IPath path = WatchPointStudioPlugin.getDefault().getStateLocation();
		String databaseFolder = CONNECTION_URL_DATABASE_FOLDER + Utility.getCurrentStudioVersion();
		path = path.append(databaseFolder);
		properties.put("hibernate.connection.url", 
						CONNECTION_URL_PROTOCOL + path.toOSString() + CONNECTION_URL_OPTIONS);
		
		this.entityManagerFactory = Persistence.createEntityManagerFactory(FILESYSTEM_APPLICATION_PERSISTENCE_UNIT, properties);
		this.initialized = true;
	}
	
	/**
	 * Close the Context, safely clearing any Context State.
	 * 
	 */
	public synchronized void closeContext()
	{
		// Check if not initialized
		if (!this.initialized)
			return;

		this.entityManagerFactory.close();
		this.entityManagerFactory = null;
		
		this.initialized = false;
	}

	/**
	 * Get the Entity Manager Factory for the filesystem persisted objects.
	 * @return
	 */
	public synchronized EntityManagerFactory getEntityManagerFactory()
	{
		if (!this.initialized)
		{
			initializeContext();
		}

		return this.entityManagerFactory;
	}

}
