/**
 * FileSystemContextFactory.java
 * Created Feb 24, 2010
 */
package com.tandbergtv.watchpoint.studio.external.fs;

import com.tandbergtv.watchpoint.studio.dataaccess.IPersistenceContext;
import com.tandbergtv.watchpoint.studio.dataaccess.PersistenceContextFactory;

/**
 * Context factory for file system backed operations
 * 
 * @author Sahil Verma
 */
public class FileSystemContextFactory extends PersistenceContextFactory {

	private String location;
	
	public FileSystemContextFactory(String location) {
		this.location = location;
	}

	/**
	 * {@inheritDoc}
	 */
	public IPersistenceContext createPersistenceContext() {
		return new FileSystemContext(location);
	}

}
