/*
 * Created on Mar 26, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.external.jpf;

import java.util.List;

import com.tandbergtv.watchpoint.studio.external.jpf.model.ResourceGroupDescriptor;
import com.tandbergtv.watchpoint.studio.external.jpf.model.ResourceTypeDescriptor;

/**
 * Plugin Management Facade Interface.
 * 
 * @author Vijay Silva
 */
public interface JPFPluginManager {
	/**
	 * Method to get the list of all Resource Type Descriptors
	 * 
	 * @return The list of supported Resource Type Descriptors
	 */
	List<ResourceTypeDescriptor> getResourceTypeDescriptors();

	/**
	 * Gets successfully loaded resource group descriptors from plugins
	 * 
	 * @return list of resource group descriptors
	 */
	List<ResourceGroupDescriptor> getResourceGroupDescriptors();

	/**
	 * Starts the plugin manager
	 */
	void initialize();

	/**
	 * Clears state and shuts down
	 */
	void close();
}
