package com.tandbergtv.watchpoint.studio.ui.deployment;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;
import org.eclipse.ui.part.EditorPart;

import com.tandbergtv.watchpoint.studio.ui.editor.WatchPointTemplateEditor;

public class JpdlDeploymentEditorPage extends EditorPart {

    WatchPointTemplateEditor editor;
    DeploymentForm deploymentForm;

    public JpdlDeploymentEditorPage(WatchPointTemplateEditor editor) {
        this.editor = editor;
    }

    @Override
    public void createPartControl(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        ScrolledForm form = toolkit.createScrolledForm(parent);
        form.setText("Template Export");
        setPartLayout(form);
        createForm(toolkit, form.getBody());
    }

    private void setPartLayout(ScrolledForm form) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        form.getBody().setLayout(layout);
    }

    private void createForm(FormToolkit toolkit, Composite form) {
        IFolder folder = getProcessFolder();
        deploymentForm = new DeploymentForm(toolkit, form, folder, editor);
        deploymentForm.create();
        folder.getWorkspace().addResourceChangeListener(new IResourceChangeListener() {
            @Override
            public void resourceChanged(IResourceChangeEvent event) {
                deploymentForm.refresh();
            }
        });
    }

    private IFolder getProcessFolder() {
        IFile file = ((IFileEditorInput)editor.getEditorInput()).getFile();
        if (file.getParent() instanceof IFolder) {
            return (IFolder)file.getParent();
        }
        return null;
    }

    @Override
    public void setFocus() {
    }

    @Override
    public void doSave(IProgressMonitor monitor) {
    }

    @Override
    public void doSaveAs() {
    }

    @Override
    public boolean isDirty() {
        return false;
    }

    @Override
    public boolean isSaveAsAllowed() {
        return false;
    }

    @Override
    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        setSite(site);
        setInput(input);
    }
}
