/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.editor;

import org.eclipse.gef.EditPart;
import org.eclipse.ui.IEditorInput;
import org.jbpm.gd.common.command.AbstractNodeCreateCommand;
import org.jbpm.gd.common.notation.Label;
import org.jbpm.gd.common.notation.Node;
import org.jbpm.gd.common.notation.NodeContainer;
import org.jbpm.gd.common.policy.ComponentEditPolicy;
import org.jbpm.gd.common.policy.GraphicalNodeEditPolicy;
import org.jbpm.gd.common.policy.XYLayoutEditPolicy;
import org.jbpm.gd.jpdl.part.GraphicalEditPartFactoryCustom;

import com.tandbergtv.watchpoint.studio.ui.command.WPNodeCreateCommand;

/**
 * A factory for creating new EditParts.
 * 
 * @author Imran Naqvi
 *
 */
public class GraphicalEditPartFactory extends GraphicalEditPartFactoryCustom {

    private IEditorInput editorInput;

    public GraphicalEditPartFactory(IEditorInput editorInput) {
        super();
        this.editorInput = editorInput;
    }
	
	/*
	 * Creates a graphical edit part for a node container.
	 */
	protected EditPart createNodeContainerGraphicalEditPart(Object model) {
		return new NodeContainerGraphicalEditPartCustom((NodeContainer)model) {
			protected ComponentEditPolicy createComponentEditPolicy() {
				return getComponentEditPolicy();
			}
		};
	}
	
	/*
	 * Creates a graphical edit part for a node.
	 */
	protected EditPart createNodeGraphicalEditPart(Object model) {
		return new WPNodeGraphicalEditPart((Node)model, editorInput) {
			protected ComponentEditPolicy createComponentEditPolicy() {
				return getComponentEditPolicy();
			}
			protected GraphicalNodeEditPolicy createGraphicalNodeEditPolicy() {
				return new WPNodeGraphicalNodeEditPolicy();
			}
		};
	}

	/*
	 * Creates a graphical edit part for a label.
	 */
	protected EditPart createLabelGraphicalEditPart(Object model) {
		return new WPLabelGraphicalEditPart((Label)model);
	}

	
	/*
	 * Creates a layout edit policy.
	 */
	protected XYLayoutEditPolicy getLayoutEditPolicy() {
		return new XYLayoutEditPolicy() {
			protected AbstractNodeCreateCommand createNodeCreateCommand() {
				return new WPNodeCreateCommand();
			}					
		};
	}

	/*
	 * Creates a component edit policy.
	 */
	protected ComponentEditPolicy getComponentEditPolicy() {
		return super.getComponentEditPolicy();
	}
}
