/*
 * Created on Sep 25, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.dailog;

import org.eclipse.jface.dialogs.IInputValidator;

/**
 * Validator for the ResourceType Parameter Value
 * 
 * @author Vijay Silva
 */
public class ResourceTypeParameterValueValidator implements IInputValidator
{
	/**
	 * Validates that the specified value is not blank.
	 * 
	 * @see org.eclipse.jface.dialogs.IInputValidator#isValid(java.lang.String)
	 */
	public String isValid(String value)
	{
		String errorMessage = null;

		if (value == null || value.trim().length() == 0)
		{
			errorMessage = "The Parameter Value cannot be blank.";
		}

		return errorMessage;
	}
}
