package com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpage;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.ResourceTypeEditor;
import com.tandbergtv.watchpoint.studio.ui.editor.resourcetype.formpart.DocumentSectionPart;

public class DocumentPage extends ResourceTypeFormPage {

	private static final String PAGE_TITLE = "Document";

	public static final String PAGE_ID = "ResourceType.DocumentPage";
	
	private ResourceTypeEditor editor = null;

	protected  DocumentSectionPart documentSectionPart;

	/**
	 * @param editor
	 *            The parent editor
	 */
	public DocumentPage(ResourceTypeEditor editor)
	{
		super(editor, PAGE_ID, PAGE_TITLE);
		this.editor = editor;
	}

	/*
	 * Create the Controls displayed in the composite
	 */
	@Override
	protected void createPageControls()
	{
		IManagedForm managedForm = this.getManagedForm();
		ScrolledForm form = managedForm.getForm();
		form.setText(editor.getResourceType().getName());

		Composite formBody = form.getBody();
		FormToolkit toolkit = managedForm.getToolkit();

		/* Create the Section Part */
		this.documentSectionPart = new DocumentSectionPart(this, formBody, toolkit, 0);
		this.documentSectionPart.getSection().setText("  System ID: " + editor.getResourceType().getSystemId());
		this.documentSectionPart.setResourceType(editor.getResourceType());
		managedForm.addPart(this.documentSectionPart);
	}

	/*
	 * Create the Form Layout
	 */
	@Override
	protected void initializePageLayout()
	{
		Composite formBody = this.getManagedForm().getForm().getBody();

		/* Set the Form Layout */
		formBody.setLayout(this.createGridLayout(1, false));

		/* Set the Layout Data for the Section in the Form */
		this.documentSectionPart.getSection().setLayoutData(this.createSectionGridData());
	}
}
