/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.model;

import org.jbpm.gd.jpdl.model.Action;
import org.jbpm.gd.jpdl.model.ActionElement;
import org.jbpm.gd.jpdl.model.Transition;

import com.tandbergtv.watchpoint.studio.util.SemanticElementCloneUtil;

/**
 * Extension of jbpm's transition model class. This extension adds some helper methods to manage the
 * actions associated with this transition.
 * 
 * @author Imran Naqvi
 * 
 */
public class WPTransition extends Transition {

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jbpm.gd.jpdl.model.Event#addActionElement(org.jbpm.gd.jpdl.model.ActionElement)
	 */
	@Override
	public void addActionElement(ActionElement actionElement) {
		/* Do not add ref action if it the transition already contains a ref action with that name */
		if (actionElement instanceof Action)
			if (hasAction(((Action) actionElement).getRefName()))
				return;
		super.addActionElement(actionElement);
	}

	/**
	 * Removes the action having the given ref name, if such an action exists for this transition.
	 * 
	 * @param refName
	 *            the ref name of the action to remove
	 */
	public void removeAction(String refName) {
		ActionElement actionElement = getAction(refName);
		if (actionElement != null)
			super.removeActionElement(actionElement);
	}

	/**
	 * Returns true if this transition has an action with the given ref name.
	 * 
	 * @param refName
	 *            ref name of the action
	 * @return true if this transition has an action with the given ref name, false otherwise
	 */
	public boolean hasAction(String refName) {
		for (ActionElement action : this.getActionElements()) {
			if (!(action instanceof Action))
				continue;
			String currentRefName = ((Action) action).getRefName();
			if (currentRefName != null && currentRefName.equals(refName))
				return true;
		}
		return false;
	}

	/**
	 * Gets the actionElement with the specified ref name.
	 * 
	 * @param refName
	 *            the ref name of the action to get
	 * @return the actionElement with the specified ref name if it exists; null otherwise
	 */
	public ActionElement getAction(String refName) {
		for (ActionElement action : this.getActionElements()) {
			if (!(action instanceof Action))
				continue;
			String currentRefName = ((Action) action).getRefName();
			if (currentRefName != null && currentRefName.equals(refName))
				return action;
		}
		return null;
	}
	
	public WPTransition cloneTransition(){
		return SemanticElementCloneUtil.cloneWPTransition(this);
	}
}
