package com.tandbergtv.watchpoint.studio.ui.preferences;

import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.jbpm.gd.jpdl.Constants;
import org.jbpm.gd.jpdl.Plugin;

/**
 * 		Main page of the Watchpoint Studio Preferences
 * 
 * @author <a href="francisco.neto@venturus.org.br">vntfrne Francisco Bento da Silva Neto</a>
 *
 */
public class MainPage extends PreferencePage implements IWorkbenchPreferencePage, Constants {
	
	public MainPage() {
		super();
		setPreferenceStore(Plugin.getDefault().getPreferenceStore());
		noDefaultAndApplyButton();
	}

	protected Control createContents(Composite composite) {
		Label label = new Label(composite, SWT.NONE);
		label.setText("Expand the tree to edit preferences for a specific feature.");
		label.pack();

		return label;
	}
	
	public void init(IWorkbench workbench) {
	}
	
}
