package com.tandbergtv.watchpoint.studio.ui.preferences;

import static com.tandbergtv.watchpoint.studio.ui.preferences.PreferenceConstants.MESSAGE_DISPATCHER_CLASS;
import static com.tandbergtv.watchpoint.studio.ui.preferences.PreferenceConstants.MESSAGE_HANDLER_CLASS;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.StringFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

import com.tandbergtv.watchpoint.studio.ui.UI;
import com.tandbergtv.watchpoint.studio.ui.WatchPointStudioPlugin;

/**
 * This class represents a preference page that
 * is contributed to the Preferences dialog. By 
 * subclassing <samp>FieldEditorPreferencePage</samp>, we
 * can use the field support built into JFace that allows
 * us to create a page that is small and knows how to 
 * save, restore and apply itself.
 * <p>
 * This page is used to modify preferences only. They
 * are stored in the preference store that belongs to
 * the main plug-in class. That way, preferences can
 * be accessed directly via the preference store.
 */
public class MappingToolPreferencePage extends FieldEditorPreferencePage implements IWorkbenchPreferencePage {

	private StringFieldEditor dispatcherClass;
	private StringFieldEditor handlerClass;

	public MappingToolPreferencePage() {
		super(GRID);
		setPreferenceStore(WatchPointStudioPlugin.getDefault().getPreferenceStore());
		setDescription(UI.PreferencePage_Title);
	}

	/**
	 * Creates the field editors. Field editors are abstractions of
	 * the common GUI blocks needed to manipulate various types
	 * of preferences. Each field editor knows how to save and
	 * restore itself.
	 */
	public void createFieldEditors() {
		dispatcherClass = new StringFieldEditor(MESSAGE_DISPATCHER_CLASS, UI.PreferencePage_MessageDispatcherClass, getFieldEditorParent());
		handlerClass = new StringFieldEditor(MESSAGE_HANDLER_CLASS, UI.PreferencePage_MessageHandlerClass, getFieldEditorParent());
		addField(dispatcherClass);
		addField(handlerClass);
		
	}

	/* (non-Javadoc)
	 * @see org.eclipse.ui.IWorkbenchPreferencePage#init(org.eclipse.ui.IWorkbench)
	 */
	public void init(IWorkbench workbench) {
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.preference.FieldEditorPreferencePage#checkState()
	 */
	@Override
	protected void checkState() {
		super.checkState();
		
		if (!isValid())
			return;
		
		setErrorMessage(null);
		setValid(true);
	}
}
