package com.tandbergtv.watchpoint.studio.ui.preferences;

import java.util.ResourceBundle;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.jface.preference.IPreferenceStore;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

import com.tandbergtv.watchpoint.studio.ui.WatchPointStudioPlugin;

/**
 * Class used to initialize default preference values.
 */
public class PreferenceInitializer extends AbstractPreferenceInitializer {
	private static final String Preferences_NAME = "/Preferences.xml";

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer#
	 * initializeDefaultPreferences()
	 */
	public void initializeDefaultPreferences() {
		IPreferenceStore store = WatchPointStudioPlugin.getDefault().getPreferenceStore();
		store.setDefault(PreferenceConstants.EXPORT_DIR, System.getProperty("java.io.tmpdir"));
		try {
			DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
			Document document = builder.parse(this.getClass().getResourceAsStream(Preferences_NAME));

			XPath xpath = XPathFactory.newInstance().newXPath();
			NodeList dispatchers = (NodeList) xpath.evaluate("/preferences/dispatcher/@name", document,
					XPathConstants.NODESET);
			NodeList handlers = (NodeList) xpath.evaluate("/preferences/handler/@name", document,
					XPathConstants.NODESET);
			store.setDefault(PreferenceConstants.MESSAGE_DISPATCHER_CLASS, dispatchers.item(0).getNodeValue());
			store.setDefault(PreferenceConstants.MESSAGE_HANDLER_CLASS, handlers.item(0).getNodeValue());
			return;
		} catch (Exception e) {
			// Just Return, and do nothing
		}

		store.setDefault(PreferenceConstants.MESSAGE_DISPATCHER_CLASS,
				"com.tandbergtv.workflow.adaptor.dispatcher.SOAPDispatcher");
		store.setDefault(PreferenceConstants.MESSAGE_HANDLER_CLASS,
				"com.tandbergtv.workflow.adaptor.handler.MappingXMLTemplateHandler");

        initializeDefaultPreferences(store);
	}

    private void initializeDefaultPreferences(IPreferenceStore store) {
        ResourceBundle bundle = ResourceBundle.getBundle("com.tandbergtv.watchpoint.studio.ui.preferences.rule-default-preference-value");
        String key = null;
        for (String code : bundle.keySet()) {
            key = new StringBuilder().append(PreferencesMessages.PREFERENCE_PREFIX).append(code.replace("-", "_")).append(PreferencesMessages.PREFERENCE_SUFFIX).toString();
            store.setDefault(key, bundle.getString(code));
        }
    }
}