package com.tandbergtv.watchpoint.studio.ui.preferences;

import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.jdt.internal.ui.preferences.OptionsConfigurationBlock.Key;
import org.eclipse.ui.preferences.IWorkingCopyManager;

import com.tandbergtv.watchpoint.studio.ui.WatchPointStudioPlugin;

public class WatchpointStudioKey extends Key {

    private String key;
    private String oldValue = "";

    public WatchpointStudioKey(String key) {
        super("", key);
        this.key = key;
    }

    @Override
    public String getStoredValue(IScopeContext context, IWorkingCopyManager manager) {
        if (context.getName().equals(DefaultScope.SCOPE)) {
            return WatchPointStudioPlugin.getDefault().getPreferenceStore().getDefaultString(key);
        } else if (manager == null) {
            return oldValue;
        }
        return WatchPointStudioPlugin.getDefault().getPreferenceStore().getString(key);
    }

    @Override
    public void setStoredValue(IScopeContext context, String value, IWorkingCopyManager manager) {
        if (manager == null) {
            oldValue = value;
        }
        WatchPointStudioPlugin.getDefault().getPreferenceStore().setValue(key, value);
    }
}