package com.tandbergtv.watchpoint.studio.ui.properties;

import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.Viewer;

import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;

public class MessageNodeVariablesInSuperStateContentProvider implements IStructuredContentProvider {

    private NodeDefinition model;
    private boolean fetchOutVariables;
    
    public MessageNodeVariablesInSuperStateContentProvider(boolean fetchOutVariables) {
        this.fetchOutVariables = fetchOutVariables;
    }

    @Override
    public void dispose() {
    }

    @Override
    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.model = (NodeDefinition) newInput;
    }

    @Override
    public Object[] getElements(Object inputElement) {
        if (model != null) {
            if (fetchOutVariables) {
                return model.getOutgoingVariables().toArray();
            } else {
                return model.getIncomingVariables().toArray();
            }
        }
        return new Object[0];
    }
}