package com.tandbergtv.watchpoint.studio.ui.properties;

import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jbpm.gd.common.properties.AbstractPropertySection;

import com.tandbergtv.watchpoint.studio.ui.util.Utility;

/**
 * Property section for viewing/setting the type of a node definition.
 * 
 * @author Imran Naqvi
 * 
 */
public class NodeDefinitionTypeSection extends AbstractPropertySection {
	
	private NodeDefinitionTypeSectionComposite composite;

	/**
	 * @see org.eclipse.ui.views.properties.tabbed.AbstractPropertySection#createControls(org.eclipse.swt.widgets.Composite,
	 *      org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage)
	 */
	public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
		super.createControls(parent, aTabbedPropertySheetPage);
		composite = new NodeDefinitionTypeSectionComposite(parent, getWidgetFactory());
	}

	/**
	 * @see org.eclipse.ui.views.properties.tabbed.AbstractPropertySection#setInput(org.eclipse.ui.IWorkbenchPart,
	 *      org.eclipse.jface.viewers.ISelection)
	 */
	public void setInput(IWorkbenchPart part, ISelection selection) {
		super.setInput(part, selection);
        if (composite != null) {
            composite.setInput(Utility.getNodeDefinition(selection), (EditorPart) (editor != null ? editor : part));
        }
	}
}