package com.tandbergtv.watchpoint.studio.ui.properties.template;

import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.TableColumn;

import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.properties.WPLabelProvider;

public class WPStartStateLabelProvider extends WPLabelProvider {

    public WPStartStateLabelProvider(TableColumn requiredColumn) {
        this.columns = new TableColumn[] { requiredColumn };
    }

    @Override
    public Image getColumnImage(Object element, int columnIndex) {
        WPVariable model = (WPVariable) element;
        if (columnIndex == 2) {
            return getCheckImage(model.isRequired());
        }
        return null;
    }

    @Override
    public String getColumnText(Object element, int columnIndex) {
        switch (columnIndex) {
        case 0:
            return ((WPVariable) element).getMappedName();
        case 1:
            return ((WPVariable) element).getName();
        case 3:
            return ((WPVariable) element).getEmptySafeType();
        case 4:
            return ((WPVariable) element).getValue();
        }
        return null;
    }
}