/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.view;

import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;
import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.dto.ResourceGroup;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;

/**
 * A decorator for IWatchPointDTO objects to get the name of the DTO's.
 * 
 * @author Imran Naqvi
 */
public class DTONameDecorator {

	IWatchPointDTO dto;
	
	
	
	/**
	 * Constructor.
	 */
	public DTONameDecorator(IWatchPointDTO dto) {
		super();
		this.dto = dto;
	}

	/**
	 * @return the name of the DTO
	 */
	public String getName(){
		if(dto instanceof WorkflowTemplateDTO)
			return ((WorkflowTemplateDTO)dto).getName();
		if(dto instanceof NodeDefinitionDTO)
			return ((NodeDefinitionDTO)dto).getName();
		if(dto instanceof ResourceType)
			return ((ResourceType)dto).getName();
		if(dto instanceof ResourceGroup)
			return ((ResourceGroup)dto).getName();
		if (dto instanceof Message)
			return ((Message) dto).getName();
		
		return "*noname*";
	}
	
	/**
	 * @return the type of object that the DTO represents
	 */
	public String getType(){
		if(dto instanceof WorkflowTemplateDTO)
			return "Template";
		if(dto instanceof NodeDefinitionDTO)
			return "Node Definition";
		if(dto instanceof ResourceType)
			return "Resource Type";
		if(dto instanceof ResourceGroup)
			return "Resource Group";
		if (dto instanceof Message)
			return "Message";
		
		return "UNKNOWN";
	}
}
