/*
 * Created on Nov 19, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.ui.view;

import java.util.ArrayList;
import java.util.List;

import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageType;

/**
 * Maintains a list of Validation Messages for a particular Validation Message Type.
 * 
 * @author Vijay Silva
 */
public class ValidationMessageGroup {

	private ValidationMessageType messageType;

	private List<ValidationMessage> messages;

	/**
	 * Constructor
	 * 
	 * @param type
	 *            The Validation Message Type
	 * @param allMessages
	 *            The list of validation messages that need to be filtered by the type
	 */
	public ValidationMessageGroup(ValidationMessageType type, List<ValidationMessage> allMessages) {
		this.messageType = type;
		this.messages = new ArrayList<ValidationMessage>();

		if (allMessages != null) {
			for (ValidationMessage message : allMessages) {
				if (message.getType() == this.messageType)
					messages.add(message);
			}
		}
	}

	/**
	 * @return the messageType
	 */
	public ValidationMessageType getMessageType() {
		return this.messageType;
	}

	/**
	 * @return the messages
	 */
	public List<ValidationMessage> getMessages() {
		return this.messages;
	}

	/**
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode() {
		if (this.messageType == null)
			return super.hashCode();

		return (this.messageType.hashCode() * 31 - 383);
	}

	/**
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj) {
		if (!(obj instanceof ValidationMessageGroup))
			return false;

		ValidationMessageGroup other = (ValidationMessageGroup) obj;
		if (this.messageType == null && other.messageType == null)
			return super.equals(obj);

		return (this.messageType == other.messageType);
	}
}
