package com.tandbergtv.watchpoint.studio.ui.view.resourcetype.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.TreeSelection;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.ide.IDE;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionDTO;
import com.tandbergtv.watchpoint.studio.ui.UIException;
import com.tandbergtv.watchpoint.studio.ui.editor.NonPersistableFileEditorInput;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;

public class EditSuperStateAction extends AbstractNodeDefinitionAction{
	private NodeDefinitionDTO nodeDefinitionDTO;
	
	@Override
	public void run(IAction action) {
		IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
		
		IFile gpdFile = ResourcesPlugin.getWorkspace().getRoot().getFile(new Path(nodeDefinitionDTO.getPath()));
		try {
			// Opening the editor
			NonPersistableFileEditorInput fileInput = new NonPersistableFileEditorInput(gpdFile, nodeDefinitionDTO);
			IDE.openEditor(activePage,	fileInput, Utility.NODEDEF_EDITOR_ID, true);
		} catch (PartInitException e) {
			throw new UIException(
					"Error opening Editor.", e);
		}
	}
	
	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		if(!selection.isEmpty()){
			
			// Gets the Node Definition
			Object element = ((TreeSelection) selection).getFirstElement();
			if (element instanceof NodeDefinitionDTO) {
				this.nodeDefinitionDTO = (NodeDefinitionDTO) element;
			}
		}
	}
	
}
