package com.tandbergtv.watchpoint.studio.ui.wizard.export;

import java.util.ArrayList;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;

import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;

public abstract class BaseExportWizardPage
		extends com.tandbergtv.watchpoint.studio.eclipse.custom.BaseExportWizardPage {

	protected ExportDestinationTab fDestinationTab;

	public BaseExportWizardPage(IStructuredSelection selection, String name, String choiceLabel) {
		super(selection, name, choiceLabel);
	}

	class ResourceTypeLabelProvider extends com.tandbergtv.watchpoint.studio.eclipse.custom.ResourceTypeLabelProvider{

		@Override
		protected Image createImage(String path) {
			if (path == null)
				return null;

			ImageDescriptor descriptor = Utility.getImageDescriptor(path);
			return new Image(Display.getCurrent(), descriptor.getImageData());
		}

	}

	protected void createTabs(TabFolder folder, IDialogSettings settings) {
		createDestinationTab(folder);
		fDestinationTab.initialize(settings);
	}

	protected void createDestinationTab(TabFolder folder) {
		fDestinationTab = new ExportDestinationTab(this);
		TabItem item = new TabItem(folder, SWT.NONE);
		item.setControl(fDestinationTab.createControl(folder));
		item.setText(PDEUIMessages.ExportWizard_destination);

	}
	
	protected String validateTabs() {
		String message = fDestinationTab.validate();
		return message;
	}
	
	@Override
	protected IProject createIProject(Object elem) {
		IProject project = null;
		if (elem instanceof IFile) {
			IFile file = (IFile) elem;
			project = file.getProject();
		} else if (elem instanceof IProject) {
			project = (IProject) elem;
		} else if (elem instanceof IJavaProject) {
			project = ((IJavaProject) elem).getProject();
		} else if (elem instanceof ResourceType) {
			ResourceType rtype = (ResourceType) elem;
			project = ResourcesPlugin.getWorkspace().getRoot().getProject(rtype.determineNameForProject());
		}
		return project;
	}
	
	public void pageChanged() {
		if (getMessage() != null)
			setMessage(null);
		String error = fExportPart.getSelectionCount() > 0 ? null : PDEUIMessages.ExportWizard_status_noselection;
		if (error == null)
			error = validateTabs();
		setErrorMessage(error);
		setPageComplete(error == null);
	}
	
	protected void saveSettings(IDialogSettings settings) {
		fDestinationTab.saveSettings(settings);
	}

	protected String getDestination() {
		return fDestinationTab.getDestination();
	}
	
	protected boolean getExportGroups() {
		return fDestinationTab.getAutoExportGroups();
	}

}
