package com.tandbergtv.watchpoint.studio.ui.wizard.resource.fields;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import com.tandbergtv.watchpoint.studio.dto.ConnectionType;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.service.IResourceTypeService;
import com.tandbergtv.watchpoint.studio.service.ServiceFactory;

public class ResourceTypeConTypeField implements IResourceTypeInputField{
	
	private Combo connTypeCombo;
	
	private Composite composite;
	
	private Map<String, ConnectionType> connTypesNameObjMap = new HashMap<String, ConnectionType>();
	
	
	public ResourceTypeConTypeField() {
		super();
	}

	public Composite getComposite(){
		return this.composite;
	}
	
	@Override
	public Composite createControls(Composite parent, FormData formData) {
		Composite systemControls = new Composite(parent, SWT.NONE);
		FormLayout layoutSys = new FormLayout();
		layoutSys.marginWidth = 0;
		layoutSys.marginHeight = 0;
		systemControls.setLayout(layoutSys);
		
		//conn type label
		Label connTypeLabel = new Label(systemControls, SWT.NONE);
		connTypeLabel.setText("Connection Type : ");
		
		//conn type combo
		connTypeCombo = new Combo(systemControls, SWT.DROP_DOWN | SWT.SINGLE | SWT.V_SCROLL | SWT.H_SCROLL | SWT.READ_ONLY);
		
		//conn type label
		FormData connTypeLabelFD = new FormData();
		connTypeLabel.setLayoutData(connTypeLabelFD);
		
		//conn type combo
		FormData connTypeComboFD = new FormData();
		connTypeComboFD.left = new FormAttachment(30, 2);
		connTypeComboFD.right = new FormAttachment(100, -10);
		connTypeCombo.setLayoutData(connTypeComboFD);
		
		
		this.composite = systemControls;
		return systemControls;
	}

	@Override
	public void setObjectValues(ResourceType rt) {
			rt.setConnectionType(connTypesNameObjMap.get(connTypeCombo.getText()));
	}

	@Override
	public void clearControls() {
	}

	@Override
	public void initValues() {
		IResourceTypeService rtService = ServiceFactory.createFactory().createResourceTypeService();
		List<ConnectionType> connTypes = rtService.getAllConnectionTypes();
		if (connTypes != null && !connTypes.isEmpty()) {
			for (ConnectionType connType : connTypes) {
				connTypeCombo.add(connType.getName());
				connTypesNameObjMap.put(connType.getName(), connType);
			}
			connTypeCombo.select(0);
		}
	}

	@Override
	public String validate() {
		return null;
	}

	@Override
	public void setValidationListener(ModifyListener validationListener) {
	}

}
