package com.tandbergtv.watchpoint.studio.ui.xml;

import java.beans.PropertyChangeEvent;
import java.util.Map;

import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.xml.XmlAdapter;
import org.jbpm.gd.jpdl.model.Action;
import org.jbpm.gd.jpdl.model.CancelTimer;
import org.jbpm.gd.jpdl.model.CreateTimer;
import org.jbpm.gd.jpdl.model.Script;
import org.jbpm.gd.jpdl.xml.TaskNodeDomAdapter;

import com.tandbergtv.watchpoint.studio.ui.model.AbstractTaskNode;
import com.tandbergtv.watchpoint.studio.ui.model.ResourceGroup;

/**
 * The Dom Adaptor for the AbstractTaskNode class.
 * 
 * @author Imran Naqvi
 * 
 */
public class AbstractTaskNodeDomAdapter extends TaskNodeDomAdapter {

	private static Map<String, String> NODE_TYPES = null;

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jbpm.gd.jpdl.xml.TaskNodeDomAdapter#getNodeTypes()
	 */
	@SuppressWarnings("unchecked")
	@Override
	protected Map getNodeTypes() {
		if (NODE_TYPES == null) {
			NODE_TYPES = super.getNodeTypes();
			NODE_TYPES.put("action", "action-element");
			NODE_TYPES.put("script", "action-element");
			NODE_TYPES.put("create-timer", "action-element");
			NODE_TYPES.put("cancel-timer", "action-element");
			NODE_TYPES.put("resource-group", "resource-group");
		}
		return NODE_TYPES;
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jbpm.gd.jpdl.xml.TaskNodeDomAdapter#initialize()
	 */
	@Override
	protected void initialize() {
		super.initialize();
		if (getSemanticElement() != null) {
			AbstractTaskNode abstractTaskNode = (AbstractTaskNode) getSemanticElement();
			addElement(abstractTaskNode.getResourceGroup());
			addElement(abstractTaskNode.getAction());
			addElement(abstractTaskNode.getScript());
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jbpm.gd.jpdl.xml.TaskNodeDomAdapter#initialize(org.jbpm.gd.common.model.SemanticElement)
	 */
	@Override
	public void initialize(SemanticElement jpdlElement) {
		super.initialize(jpdlElement);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jbpm.gd.jpdl.xml.TaskNodeDomAdapter#doModelAdd(org.jbpm.gd.common.xml.XmlAdapter)
	 */
	@Override
	protected void doModelAdd(XmlAdapter child) {
		String type = child.getElementType();
		SemanticElement jpdlElement = createSemanticElementFor(child);
		AbstractTaskNode node = (AbstractTaskNode) getSemanticElement();
		if ("action".equals(type)) {
			child.initialize(jpdlElement);
			node.setAction((Action) jpdlElement);
		}
		else if ("script".equals(type)) {
			child.initialize(jpdlElement);
			node.setScript((Script) jpdlElement);
		}
		else if ("create-timer".equals(type)) {
			child.initialize(jpdlElement);
			node.setCreateTimer((CreateTimer) jpdlElement);
		}
		else if ("cancel-timer".equals(type)) {
			child.initialize(jpdlElement);
			node.setCancelTimer((CancelTimer) jpdlElement);
		}
		else if ("resource-group".equals(type)) {
			child.initialize(jpdlElement);
			node.setResourceGroup((ResourceGroup) jpdlElement);
		}
		else
			super.doModelAdd(child);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jbpm.gd.jpdl.xml.TaskNodeDomAdapter#doModelRemove(org.jbpm.gd.common.xml.XmlAdapter)
	 */
	@Override
	protected void doModelRemove(XmlAdapter child) {
		String type = child.getElementType();
		AbstractTaskNode node = (AbstractTaskNode) getSemanticElement();
		if ("action".equals(type)) {
			node.setAction(null);
		}
		else if ("script".equals(type)) {
			node.setScript(null);
		}
		else if ("create-timer".equals(type)) {
			node.setCreateTimer(null);
		}
		else if ("cancel-timer".equals(type)) {
			node.setCancelTimer(null);
		}
		else if ("resource-group".equals(type)) {
			node.setResourceGroup(null);
		}
		else
			super.doModelRemove(child);

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jbpm.gd.jpdl.xml.TaskNodeDomAdapter#doModelUpdate(java.lang.String,
	 *      java.lang.String)
	 */
	@Override
	protected void doModelUpdate(String name, String newValue) {
		super.doModelUpdate(name, newValue);
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jbpm.gd.jpdl.xml.TaskNodeDomAdapter#propertyChange(java.beans.PropertyChangeEvent)
	 */
	public void propertyChange(PropertyChangeEvent evt) {
		if ("action".equals(evt.getPropertyName())) {
			setElement("action", (SemanticElement) evt.getOldValue(),
					(SemanticElement) evt.getNewValue());
		}
		else if ("script".equals(evt.getPropertyName())) {
			setElement("script", (SemanticElement) evt.getOldValue(),
					(SemanticElement) evt.getNewValue());
		}
		else if ("createTimer".equals(evt.getPropertyName())) {
			setElement("create-timer", (SemanticElement) evt.getOldValue(),
					(SemanticElement) evt.getNewValue());
		}
		else if ("cancelTimer".equals(evt.getPropertyName())) {
			setElement("cancel-timer", (SemanticElement) evt.getOldValue(),
					(SemanticElement) evt.getNewValue());
		}
		else if ("cancelTimer".equals(evt.getPropertyName())) {
			setElement("cancel-timer", (SemanticElement) evt.getOldValue(),
					(SemanticElement) evt.getNewValue());
		}
		else if ("resourceGroupAdd".equals(evt.getPropertyName())) {
			setElement("resource-group", (SemanticElement) evt.getOldValue(),
					(SemanticElement) evt.getNewValue());
		}
		else
			super.propertyChange(evt);
	}

}
