package com.tandbergtv.watchpoint.studio.ui.xml;

import java.beans.PropertyChangeEvent;

import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.jpdl.xml.VariableDomAdapter;

import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;

/**
 * Dom Adapter for WPVariables.
 * 
 * @author Imran Naqvi
 * 
 */
public class WPVariableDomAdapter extends VariableDomAdapter {

	/* (non-Javadoc)
	 * @see org.jbpm.gd.jpdl.xml.VariableDomAdapter#initialize()
	 */
	@Override
	protected void initialize() {
		super.initialize();
		WPVariable variable = (WPVariable) getSemanticElement();
		if (variable != null) {
			setAttribute("type", variable.getType());
			setAttribute("value", variable.getValue());
		}
	}

	/* (non-Javadoc)
	 * @see org.jbpm.gd.jpdl.xml.VariableDomAdapter#initialize(org.jbpm.gd.common.model.SemanticElement)
	 */
	public void initialize(SemanticElement jpdlElement) {
		super.initialize(jpdlElement);
		WPVariable variable = (WPVariable) jpdlElement;
		variable.setType(getAttribute("type"));
		variable.setValue(getAttribute("value"));
		
	}

	/* (non-Javadoc)
	 * @see org.jbpm.gd.jpdl.xml.VariableDomAdapter#propertyChange(java.beans.PropertyChangeEvent)
	 */
	@Override
	public void propertyChange(PropertyChangeEvent evt) {
		if ("type".equals(evt.getPropertyName())) {
			setAttribute("type", (String) evt.getNewValue());
		} else if ("value".equals(evt.getPropertyName())) {
			setAttribute("value", (String) evt.getNewValue());
		}
		super.propertyChange(evt);
	}

	/* (non-Javadoc)
	 * @see org.jbpm.gd.jpdl.xml.VariableDomAdapter#doModelUpdate(java.lang.String, java.lang.String)
	 */
	protected void doModelUpdate(String name, String newValue) {
		WPVariable variable = (WPVariable) getSemanticElement();
		if ("type".equals(name)) {
			variable.setType(newValue);
		} else if ("value".equals(name)) {
			variable.setValue(newValue);
			
		}
		else
			super.doModelUpdate(name, newValue);
	}
}
