/**
 * 
 */
package com.tandbergtv.watchpoint.studio.usermgmt;

/**
 * Default implementation of the User ID generator that builds the User Id by concatenating all the
 * fields of the User object and separating them using a fixed Separator string.
 * 
 * @author DReddy
 */
public class DefaultUserIdGenerator implements IUserIdGenerator {

	// The Separator used when generating the User Id
	private static final String Token = "#";

	/**
	 * @see com.tandbergtv.watchpoint.studio.usermgmt.IUserIdGenerator#generateUser(java.lang.String)
	 */
	public User generateUser(String userId) throws UserManagementException {
		if (userId != null || !"".equals(userId)) {
			String values[] = userId.split(Token);

			if (values.length == 4) {
				String id = values[0];
				String ipAddr = values[1];
				long timeStamp = Long.parseLong(values[2]);
				int randomNum = Integer.parseInt(values[3]);
				return new User(id, ipAddr, timeStamp, randomNum);
			}
		}
		throw new UserManagementException("Failed to generate User from UserId");

	}

	/**
	 * @see com.tandbergtv.watchpoint.studio.usermgmt.IUserIdGenerator#generateUserId(com.tandbergtv.watchpoint.studio.usermgmt.User)
	 */
	public String generateUserId(User user) throws UserManagementException {
		StringBuffer userId = new StringBuffer();
		if (user.getUserName() == null)
			throw new UserManagementException("Username can not be null");
		userId.append(user.getUserName());
		userId.append(Token);

		if (user.getIpAddress() == null)
			throw new UserManagementException("IP Address can not be null");
		userId.append(user.getIpAddress());
		userId.append(Token);

		userId.append(user.getTimeStamp());
		userId.append(Token);
		userId.append(user.getRandomNumber());

		return userId.toString();

	}
}
