package com.tandbergtv.watchpoint.studio.util;

import java.util.ArrayList;
import java.util.List;

import com.tandbergtv.watchpoint.studio.dataaccess.ConnectionTypeDAI;
import com.tandbergtv.watchpoint.studio.dataaccess.DataAccessFactory;
import com.tandbergtv.watchpoint.studio.dataaccess.DataAccessInterface;
import com.tandbergtv.watchpoint.studio.dataaccess.IPersistenceContext;
import com.tandbergtv.watchpoint.studio.dataaccess.jpa.JPAContext;
import com.tandbergtv.watchpoint.studio.dataaccess.jpa.JPAPersistenceContext;
import com.tandbergtv.watchpoint.studio.dto.ConnectionType;
import com.tandbergtv.watchpoint.studio.dto.IPersistable;

public class ResourceTypeRequiredDataInitializer {
	private DataAccessFactory daFactory;
	private IPersistenceContext context;
	
	public ResourceTypeRequiredDataInitializer() {
		this.daFactory = DataAccessFactory.createFactory();
		this.context = new JPAPersistenceContext(JPAContext.getContext().getEntityManagerFactory());
		context.initialize();
	}
	
	public void initializeData(RequireInitializeValuesEntities entity){
		switch (entity) {
		case CONNECTION_TYPE:
			initializeConTypeValues();
			break;

		default:
			break;
		}
		
	}
	
	private void initializeConTypeValues(){
		List<IPersistable> entities = new ArrayList<IPersistable>();
		ConnectionType url = new ConnectionType(0, "URL");
		ConnectionType ipPort = new ConnectionType(1, "IP/Port");
		ConnectionType email = new ConnectionType(2, "Email");
		entities.add(url);
		entities.add(ipPort);
		entities.add(email);
		
		createConTypeEntities(entities);
	}
	
	private void createConTypeEntities(List<IPersistable> entities){
		ConnectionTypeDAI conTypeDAO = createConnectionTypeDAO(context);

		if (conTypeDAO.findAll().isEmpty()) {
			context.beginTransaction();
			for (IPersistable entity : entities) {
				conTypeDAO.create((ConnectionType) entity);
			}
			context.commitTransaction();
		}
	}
	
	private ConnectionTypeDAI createConnectionTypeDAO(IPersistenceContext context)
	{
		Class<ConnectionType> entityClass = ConnectionType.class;
		DataAccessInterface<ConnectionType, ?> dao = daFactory.createDataAccessObject(
				entityClass, context);
		return (ConnectionTypeDAI) dao;
	}
}
