package com.tandbergtv.watchpoint.studio.util;

/**
 * @author Raj Prakash
 *
 * Data Object to hold Timer Expression used in Due Date & Duration
 */
public class TimerExpression {
	
	public static final String ADDITION_OPERATOR = "+";
	public static final String MULTIPLICATION_OPERATOR = "*";

	private String operand1;
	private String operand2;
	private String operator;
	
	/**
	 * Default Constructor
	 */
	public TimerExpression() {
		
	}
	
	/**
	 * @param operand1
	 * @param operator
	 * @param operand2
	 */
	public TimerExpression(String operand1, String operator, String operand2) {
		this.operand1 = operand1;
		this.operator = operator;
		this.operand2 = operand2;
	}

	/**
	 * @return the operand1
	 */
	public String getOperand1() {
		return operand1;
	}

	/**
	 * @param operand1 the operand1 to set
	 */
	public void setOperand1(String operand1) {
		this.operand1 = operand1;
	}

	/**
	 * @return the operand2
	 */
	public String getOperand2() {
		return operand2;
	}

	/**
	 * @param operand2 the operand2 to set
	 */
	public void setOperand2(String operand2) {
		this.operand2 = operand2;
	}

	/**
	 * @return the operator
	 */
	public String getOperator() {
		return operator;
	}

	/**
	 * @param operator the operator to set
	 */
	public void setOperator(String operator) {
		this.operator = operator;
	}
	
	
}
