/*
 * Created on Jul 11, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.validation;

import java.util.List;

/**
 * Interface for a validator that can validate objects of a certain type.
 * 
 * @param <VO>
 *            The type of the object that can be validated
 * 
 * @author Vijay Silva
 */
public interface IValidator<VO>
{
	/**
	 * Validate the target object which must be of type VO.
	 * 
	 * @param target
	 *            The target object to validate
	 * @return The list of validation messages resulting from the validation.
	 */
	List<ValidationMessage> validate(VO target);

	/**
	 * Get the Validation Rules used for validation.
	 * 
	 * @return The list of validation rules for this rule validator
	 */
	List<IValidationRule<VO>> getRules();

	/**
	 * Set the Validation Rules to use when validating an object.
	 * 
	 * @param validationRules
	 *            The list of validation rules
	 */
	void setRules(List<IValidationRule<VO>> validationRules);
}
