package com.tandbergtv.watchpoint.studio.validation.impl;

import java.util.HashSet;
import java.util.Set;

import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.ReturnStatement;
import org.eclipse.jdt.core.dom.SimpleName;

public class UsedVariablesCollectorVisitor extends ASTVisitor {

    private Set<String> usedVariables = new HashSet<String>();

    public boolean visit(ReturnStatement node) {
        node.accept(new ASTVisitor() {
            @Override
            public boolean visit(SimpleName node) {
                usedVariables.add(node.getIdentifier());
                return true;
            }
        });
        return true;
    }

    public Set<String> getUsedVariables() {
        return usedVariables;
    }
}
