/**
 * 
 */
package com.tandbergtv.watchpoint.studio.validation.model;

import java.util.List;

import com.tandbergtv.watchpoint.studio.ui.model.LoopNode;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;

/**
 * Validation Model Object that represents a Loop Node Expression.
 * 
 * @author Patrik Araujo
 */
public class LoopNodeExpression extends ContainerValidationContext
{
	protected LoopNode loopNode;

	/**
	 * Constructor.
	 * 
	 * @param template
	 *            the workflow template that contains the loop node
	 * @param variables
	 *            the list of variables that may be used in the expression
	 * @param loopNode
	 *            the loop node with the expression to validate
	 */
	public LoopNodeExpression(WorkflowTemplate template, List<WPVariable> variables,
			LoopNode loopNode)
	{
		super(template, variables);
		this.loopNode = loopNode;
	}

	/**
	 * Constructor.
	 * 
	 * @param nodeDefinition
	 *            the node definition that contains the loop node
	 * @param variables
	 *            the list of variables that may be used in the expression
	 * @param loopNode
	 *            the Loop Node with the expression to validate
	 */
	public LoopNodeExpression(NodeDefinition nodeDefinition, List<WPVariable> variables,
			LoopNode loopNode)
	{
		super(nodeDefinition, variables);
		this.loopNode = loopNode;
	}

	/**
	 * Get the Loop node
	 * 
	 * @return the Loop Node
	 */
	public LoopNode getLoopNode()
	{
		return this.loopNode;
	}
}
