/**
 * 
 */
package com.tandbergtv.watchpoint.studio.validation.rules.expression;

import java.util.ArrayList;
import java.util.List;

import com.tandbergtv.watchpoint.studio.util.DecisionExprValidationUtil;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationRule;
import com.tandbergtv.watchpoint.studio.validation.impl.ValidationMessageAdder;
import com.tandbergtv.watchpoint.studio.validation.model.ConditionExpression;

/**
 * This class validates the Condition Expression Rules
 * @author DReddy
 *
 */
public class ConditionExprValidateRule extends ValidationRule<ConditionExpression> {

	/* (non-Javadoc)
	 * @see com.tandbergtv.watchpoint.studio.validation.IValidationRule#validateRule(java.lang.Object)
	 */
	public List<ValidationMessage> validateRule(ConditionExpression target) {
		List<ValidationMessage> messages= null;
		Object[] valMsg =DecisionExprValidationUtil.validateConditionExpr(target);
		if(valMsg!=null){
			messages = new ArrayList<ValidationMessage>();
            if (valMsg.length <= 2) {
                ValidationMessageAdder.getInstance().addValidationMessage(messages, valMsg[0], (ValidationMessageCode) valMsg[1]);
            } else {
                ValidationMessageAdder.getInstance().addValidationMessage(messages, valMsg[0], (ValidationMessageCode) valMsg[1], (List<String>) valMsg[2]);
            }
		}
		return messages;
	}



}
