/*
 * Created on Nov 16, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.automatictasknode;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

import org.jbpm.gd.common.model.GenericElement;
import org.jbpm.gd.jpdl.model.Action;

import com.tandbergtv.watchpoint.studio.ui.model.AutomaticTaskNode;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode;
import com.tandbergtv.watchpoint.studio.validation.ValidationRule;
import com.tandbergtv.watchpoint.studio.validation.impl.ValidationMessageAdder;

/**
 * Validates that all arguments / variables defined in the Automatic Task Node Action are valid (not
 * duplicate and not blank).
 * 
 * @author Vijay Silva
 */
public class ActionVariableRule extends ValidationRule<AutomaticTaskNode>
{
	/**
	 * @param target
	 *            The Automatic Task Node to validate
	 * @return The list of validation messages
	 * @see com.tandbergtv.watchpoint.studio.validation.IValidationRule#validateRule(java.lang.Object)
	 */
	public List<ValidationMessage> validateRule(AutomaticTaskNode target)
	{
		List<ValidationMessage> messages = new ArrayList<ValidationMessage>();

		Action action = target.getAction();
		if (action != null)
		{
			GenericElement[] elements = action.getGenericElements();

			if (elements != null)
			{
				boolean hasBlanks = false;
				Set<String> names = new HashSet<String>();
				Set<String> duplicates = new HashSet<String>();

				for (GenericElement element : elements)
				{
					String name = element.getName();
					if (name != null)
						name = name.trim();

					if (name == null || name.length() == 0)
						hasBlanks = true;
					else if (!names.contains(name))
						names.add(name);
					else
						duplicates.add(name);
				}

				this.validateBlankNames(target, hasBlanks, messages);
				this.validateDuplicateNames(target, duplicates, messages);
			}
		}

		return messages;
	}

	/*
	 * Validate if any of the variables in the action of the node contains blank names
	 */
	private void validateBlankNames(AutomaticTaskNode node, boolean hasBlanks,
			List<ValidationMessage> messages)
	{
		if (hasBlanks)
		{
			ValidationMessageAdder.getInstance().addValidationMessage(messages, node, ValidationMessageCode.NODE_ACTION_VARIABLES_BLANK_NAMES);
		}
	}

	/*
	 * Validate if any of the variables in the action of the node contains blank names
	 */
	private void validateDuplicateNames(AutomaticTaskNode node, Set<String> duplicates,
			List<ValidationMessage> messages)
	{
		for (String name : duplicates)
		{
			ValidationMessageCode code = ValidationMessageCode.NODE_ACTION_VARIABLES_DUPLICATE_NAMES;
			List<String> parameters = new ArrayList<String>();
			parameters.add(name);
			ValidationMessageAdder.getInstance().addValidationMessage(messages, node, code, parameters);
		}
	}
}
