/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.model;

import com.tandbergtv.watchpoint.studio.debugger.model.JpdlDebugElement;
import com.tandbergtv.watchpoint.studio.debugger.model.JpdlDebugTarget;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;

public class JpdlThread
extends JpdlDebugElement
implements IThread {
    private IBreakpoint[] fBreakpoints;
    private boolean fStepping = false;

    public JpdlThread(JpdlDebugTarget target) {
        super(target);
    }

    public IStackFrame[] getStackFrames() throws DebugException {
        if (this.isSuspended()) {
            return ((JpdlDebugTarget)this.getDebugTarget()).getStackFrames();
        }
        return new IStackFrame[0];
    }

    public boolean hasStackFrames() throws DebugException {
        return this.isSuspended();
    }

    public int getPriority() throws DebugException {
        return 0;
    }

    public IStackFrame getTopStackFrame() throws DebugException {
        IStackFrame[] frames = this.getStackFrames();
        if (frames.length > 0) {
            return frames[0];
        }
        return null;
    }

    public String getName() {
        block3: {
            try {
                if (this.getTopStackFrame() != null) break block3;
                return "<terminated>";
            }
            catch (DebugException e) {
                return "";
            }
        }
        return this.getTopStackFrame().getName();
    }

    public IBreakpoint[] getBreakpoints() {
        if (this.fBreakpoints == null) {
            return new IBreakpoint[0];
        }
        return this.fBreakpoints;
    }

    protected void setBreakpoints(IBreakpoint[] breakpoints) {
        this.fBreakpoints = breakpoints;
    }

    public boolean canResume() {
        return this.isSuspended();
    }

    public boolean canSuspend() {
        return !this.isSuspended();
    }

    public boolean isSuspended() {
        return this.getDebugTarget().isSuspended();
    }

    public void resume() throws DebugException {
        this.getDebugTarget().resume();
    }

    public void suspend() throws DebugException {
        this.getDebugTarget().suspend();
    }

    public boolean canStepInto() {
        return false;
    }

    public boolean canStepOver() {
        return this.isSuspended();
    }

    public boolean canStepReturn() {
        return false;
    }

    public boolean isStepping() {
        return this.fStepping;
    }

    public void stepInto() throws DebugException {
    }

    public void stepOver() throws DebugException {
        ((JpdlDebugTarget)this.getDebugTarget()).step();
    }

    public void stepReturn() throws DebugException {
    }

    public boolean canTerminate() {
        return !this.isTerminated();
    }

    public boolean isTerminated() {
        return this.getDebugTarget().isTerminated();
    }

    public void terminate() throws DebugException {
        this.getDebugTarget().terminate();
    }

    protected void setStepping(boolean stepping) {
        this.fStepping = stepping;
    }
}

