/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation;

import com.tandbergtv.watchpoint.studio.debugger.runtime.nodesimulation.NodeSimulator;
import com.tandbergtv.workflow.core.MailNode;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jbpm.context.def.VariableAccess;
import org.jbpm.graph.def.Transition;

public class MailNodeSimulator
extends NodeSimulator {
    protected List<Transition> leavingTransitions = null;
    protected String to;
    private String subject;
    private String text;
    private String attachment;

    @Override
    public void simulate() {
        MailNode mail = (MailNode)this.node;
        this.to = this.evaluate(mail.getTo());
        this.subject = this.evaluate(mail.getSubject());
        this.text = this.evaluate(mail.getText());
        this.attachment = this.evaluate(mail.getAttachment());
    }

    protected String evaluate(String expression) {
        Object result = expression;
        if (expression != null && !expression.trim().isEmpty()) {
            try {
                result = this.executionContext.getVariable(expression);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String resultStr = null;
        resultStr = result != null ? result.toString() : expression;
        return resultStr;
    }

    @Override
    public boolean fail() {
        return false;
    }

    @Override
    public Collection<VariableAccess> getVariables() {
        return Collections.emptyList();
    }

    public String getTo() {
        return this.to;
    }

    public String getSubject() {
        return this.subject;
    }

    public String getText() {
        return this.text;
    }

    public String getAttachment() {
        return this.attachment;
    }
}

