/*
 * Decompiled with CFR 0.152.
 */
package com.tandbergtv.watchpoint.studio.debugger.ui;

import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

public class VariableValuesTableLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    public static final String REQUIRED_VARIABLE_PREFIX = "* ";

    public String getColumnText(Object element, int columnIndex) {
        String result = "";
        WPVariable variable = (WPVariable)element;
        switch (columnIndex) {
            case 0: {
                result = this.getVariableName(variable);
                break;
            }
            case 1: {
                result = this.getVariableType(variable);
                break;
            }
            case 2: {
                result = this.getVariableValue(variable);
                break;
            }
            default: {
                result = "";
            }
        }
        return result;
    }

    protected String getVariableType(WPVariable variable) {
        String result = variable.getType();
        return result;
    }

    protected String getVariableValue(WPVariable variable) {
        String result = variable.getValue();
        if (result == null) {
            result = "";
        }
        return result;
    }

    protected String getVariableName(WPVariable variable) {
        String result = "";
        if (variable.isRequired()) {
            result = REQUIRED_VARIABLE_PREFIX;
        }
        result = String.valueOf(result) + variable.getMappedName();
        return result;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public Color getForeground(Object element, int columnIndex) {
        WPVariable variable = (WPVariable)element;
        if (!variable.isWritable()) {
            return Display.getCurrent().getSystemColor(15);
        }
        if (variable.getName() == null) {
            return Display.getCurrent().getSystemColor(16);
        }
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }
}

