package com.tandbergtv.watchpoint.studio.debugger.core;

import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorPart;

import com.tandbergtv.watchpoint.studio.debugger.model.NodeBreakpoint;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;

public class BreakpointListener implements IBreakpointListener {

    @Override
    public void breakpointAdded(IBreakpoint breakpoint) {
        refreshEditPart(breakpoint);
    }

    @Override
    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        refreshEditPart(breakpoint);
    }

    @Override
    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
    }

    private void refreshEditPart(IBreakpoint breakpoint) {
        Display.getDefault().syncExec(new RefreshBreakpoints(breakpoint));
    }
}

class RefreshBreakpoints implements Runnable {
    
    private IBreakpoint breakpoint;

    public RefreshBreakpoints(IBreakpoint breakpoint) {
        this.breakpoint = breakpoint;
    }

    @Override
    public void run() {
        IResource resource  = breakpoint.getMarker().getResource();
        String nodeName = ((NodeBreakpoint)breakpoint).getNodeName();

        IEditorPart editorPart = Utility.getEditor(Utility.TEMPLATE_EDITOR_ID, resource);
        Utility.refreshEditPartByNodeName(editorPart, nodeName);
    }
    
}