package com.tandbergtv.watchpoint.studio.debugger.runtime.parser;

import java.util.TreeMap;

import com.tandbergtv.watchpoint.studio.debugger.launching.TemplateLauncherConstants;
import com.tandbergtv.watchpoint.studio.eclipse.custom.LaunchConfigurationInfoCustom;
 
/**
 * Class imported from the Eclipse's Launch Configuration framework with slight changes to
 * remove any eclipse dependence.
 * 
 * @see org.eclipse.debug.internal.core.LaunchConfigurationInfo
 */
public class LaunchConfigurationInfo extends com.tandbergtv.watchpoint.studio.eclipse.custom.LaunchConfigurationInfoCustom{
	
	/**
	 * This configurations attribute table. Keys are <code>String</code>s and
	 * values are one of <code>String</code>, <code>Integer</code>, or
	 * <code>Boolean</code>.
	 */
	private TreeMap fAttributes;
	
	
	protected LaunchConfigurationInfo() {
		setAttributeTable(new TreeMap());
	}
	
	@Override
	protected TreeMap getAttributeTable() {
		return fAttributes;
	}
	
	@Override
	protected void setAttributeTable(TreeMap table) {
		fAttributes = table;
	}
	
	/**
	 * @see java.lang.Object#hashCode()
	 */
	public int hashCode() {
		return TemplateLauncherConstants.LAUNCH_CONFIGURATION_TYPE_IDENTIFIER.hashCode() + fAttributes.size();
	}

	@Override
	protected LaunchConfigurationInfoCustom getCopy() {
		LaunchConfigurationInfo copy = new LaunchConfigurationInfo();
		copy.setAttributeTable(getAttributes());
		return copy;
	}
}

