package com.tandbergtv.watchpoint.studio.debugger.ui;

import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;

import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;

/**
 * Label provider for the TemplateNodesTable
 * 
 * @author <a href="mailto:francisco.bento.silva.neto@ericsson.com">efrasio - Francisco Bento da Silva Neto</a>
 *
 */
public class VariableValuesTableLabelProvider extends LabelProvider implements ITableLabelProvider, ITableColorProvider {

	public static final String REQUIRED_VARIABLE_PREFIX = "* ";
	
	/**
	 * @see org.eclipse.jface.viewers.ITableLabelProvider#getColumnText(java.lang.Object, int)
	 */
	public String getColumnText(Object element, int columnIndex) {
		String result = "";
		WPVariable variable = (WPVariable) element;
		switch (columnIndex) {
			case 0 : // VAR NAME
				result = getVariableName(variable);
				break;
			case 1 : // VAR TYPE
				result = getVariableType(variable);					
				break;
			case 2 : // VAR VALUE
				result = getVariableValue(variable);					
				break;
			default :
				result = "";
		}
		return result;
	}
	
	protected String getVariableType(WPVariable variable) {
		String result = variable.getType();
		return result;
	}
	
	protected String getVariableValue(WPVariable variable) {
		String result = variable.getValue();
		if (result == null) {
			result = "";
		}
		return result;
	}
	
	protected String getVariableName(WPVariable variable) {
		String result = "";
		if (variable.isRequired()) {
			result = REQUIRED_VARIABLE_PREFIX;
		}
		result += variable.getMappedName();
		return result;
	}
	
	public Image getColumnImage(Object element, int columnIndex) {
		return null;
	}

	public Color getForeground(Object element, int columnIndex) {
		WPVariable variable = (WPVariable) element;
		// display grayed color for write variables
		if (!variable.isWritable()) {
			return Display.getCurrent().getSystemColor(SWT.COLOR_GRAY);
		}
		// display grayed color for variables not mapped in the template
		if (variable.getName() == null) {
			return Display.getCurrent().getSystemColor(SWT.COLOR_DARK_GRAY);
		}
		return null;
	}

	public Color getBackground(Object element, int columnIndex) {
		return null;
	}

}

