/**
 * JPFContextFactory.java
 * Created Feb 18, 2010
 */
package com.tandbergtv.watchpoint.studio.external.jpf;

import com.tandbergtv.watchpoint.studio.dataaccess.IPersistenceContext;
import com.tandbergtv.watchpoint.studio.dataaccess.PersistenceContextFactory;

/**
 * @author Sahil Verma
 */
public class JPFContextFactory extends PersistenceContextFactory {

	private String path;
	
	/**
	 * Creates the {@link JPFContextFactory}
	 */
	public JPFContextFactory(String path) {
		super();
		this.path = path;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public IPersistenceContext createPersistenceContext() {
		return new JPFContext(path);
	}

}
