/*
 * Created on Sep 5, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.external.wpexport.impl;

/**
 * The set of constants that are required when building the plug-in XML document for the WatchPoint
 * system. The parameters defined by all extension points in the WatchPoint plug-in are defined.
 * 
 * @author Vijay Silva
 */
public final class WatchPointPluginConstants
{
	/*
	 * Cannot instantiate
	 */
	private WatchPointPluginConstants()
	{
	}

	/**
	 * The Plug-in ID for the WatchPoint Workflow plug-in
	 */
	public static final String PLUGIN_ID = "com.tandbergtv.workflow";

	/**
	 * The Extension Point ID for the Resource Type extension point in the WatchPoint Plug-in.
	 */
	public static final String EXTENSION_POINT_ID_RESOURCE_TYPE = "resourcetype";

	/**
	 * The Extension Point ID for the Resource Group extension point in the WatchPoint Plug-in.
	 */
	public static final String EXTENSION_POINT_ID_RESOURCE_GROUP = "resourcegroup";

	/**
	 * Folder path relative to the Plug-in Root Folder (which may be null or empty string in value)
	 * that will be used for the library files (jars) to include for the plug-in.
	 */
	public static final String PLUGIN_LIB_FOLDER_NAME = "lib";

	/**
	 * Folder path relative to the Plug-in Root Folder (which may be null or empty string in value)
	 * that will be used for the code files ('.class') to include for the plug-in.
	 */
	public static final String PLUGIN_CLASS_FOLDER_NAME = "classes";

	/**
	 * Folder path relative to the Plug-in Root Folder (which may be null or empty string in value)
	 * that will be used for the resource files (configuration files) to include for the plug-in.
	 */
	public static final String PLUGIN_RESOURCE_FOLDER_NAME = "resources";
	
	/**
	 * Name of directory under the workflow root directory where templates are exported 
	 */
	public static final String TEMPLATE_FOLDER = "templates";
	
	/**
	 * Name of subdirectory under resources/ that contains node definitions 
	 */
	public static final String PLUGIN_NODE_FOLDER = "node";
	
	/**
	 * Name of resource type plugin file
	 */
	public static final String RESOURCE_TYPE_PLUGIN_FILE_NAME = "plugin.xml";
	
	/**
	 * Name of resource type build file
	 */
	public static final String RESOURCE_TYPE_BUILD_FILE_NAME = "build.xml";
	
	/**
	 * Name of resource type build properties file
	 */
	public static final String RESOURCE_TYPE_BUILD_PROPERTIES_FILENAME = "build.properties";

	// ========================================================================
	// ===================== RESOURCE TYPE EXTENSION POINT PARAMETERS
	// ========================================================================

	/**
	 * Resource Type Parameter: systemId.
	 */
	public static final String RT_PARAM_SYSTEM_ID = "systemId";

	/**
	 * Resource Type Parameter: name.
	 */
	public static final String RT_PARAM_NAME = "name";

	/**
	 * Resource Type Parameter: createDate.
	 */
	public static final String RT_PARAM_CREATE_DATE = "createDate";

	/**
	 * Resource Type Parameter: description.
	 */
	public static final String RT_PARAM_DESCRIPTION = "description";

	/**
	 * Resource Type Parameter: communication.
	 */
	public static final String RT_PARAM_COMMUNICATION = "communication";

	/**
	 * Resource Type Parameter: messages.
	 */
	public static final String RT_PARAM_MESSAGES = "messages";

	/**
	 * Resource Type Parameter: defaultProtocol.
	 */
	public static final String RT_PARAM_DEFAULT_PROTOCOL = "defaultProtocol";

	/**
	 * Resource Type Parameter: message.
	 */
	public static final String RT_PARAM_MESSAGE = "message";

	/**
	 * Resource Type Parameter for the message name.
	 */
	public static final String RT_PARAM_MESSAGE_NAME = "name";

	/**
	 * Resource Type Parameter for the message UID.
	 */
	public static final String RT_PARAM_MESSAGE_UID = "uid";

	/**
	 * Resource Type Parameter for the message description.
	 */
	public static final String RT_PARAM_MESSAGE_DESCRIPTION = "description";

	/**
	 * Resource Type Parameter for the message protocol (if different from default).
	 */
	public static final String RT_PARAM_MESSAGE_PROTOCOL = "protocol";

	/**
	 * Resource Type Parameter: adaptor.
	 */
	public static final String RT_PARAM_ADAPTOR = "adaptor";

	/**
	 * Resource Type Parameter defining the default adaptor.
	 */
	public static final String RT_PARAM_ADAPTOR_DEFAULT = "default";

	/**
	 * Resource Type Parameter for the message identifier class used by the default adaptor.
	 */
	public static final String RT_PARAM_MESSAGE_IDENTIFIER = "messageIdentifierClass";

	/**
	 * Resource Type Parameter defining the custom adaptor.
	 */
	public static final String RT_PARAM_ADAPTOR_CUSTOM = "custom";

	/**
	 * Resource Type Parameter for the custom adaptor class name.
	 */
	public static final String RT_PARAM_ADAPTOR_CLASS = "class";

	/**
	 * Resource Type Parameter for the custom adaptor scope.
	 */
	public static final String RT_PARAM_ADAPTOR_SCOPE = "scope";

	/**
	 * Resource Type Parameter value allowed for Adaptor Scope: 'application'.
	 */
	public static final String RT_VALUE_ADAPTOR_SCOPE_APPLICATION = "application";

	/**
	 * Resource Type Parameter value allowed for Adaptor Scope: 'message'.
	 */
	public static final String RT_VALUE_ADAPTOR_SCOPE_MESSAGE = "message";

	/**
	 * Resource Type Parameter for the adaptor parameters.
	 */
	public static final String RT_PARAM_ADAPTOR_PARAMETERS = "init-params";

	/**
	 * Resource Type Parameter for a single adaptor parameter.
	 */
	public static final String RT_PARAM_ADAPTOR_PARAMETER = "parameter";

	/**
	 * Resource Type Parameter for the key of a single adaptor parameter.
	 */
	public static final String RT_PARAM_ADAPTOR_PARAMETER_KEY = "key";

	/**
	 * Resource Type Parameter for the value of a single adaptor parameter.
	 */
	public static final String RT_PARAM_ADAPTOR_PARAMETER_VALUE = "value";

	/**
	 * Resource Type Parameter: management.
	 */
	public static final String RT_PARAM_MANAGEMENT = "management";

	/**
	 * Resource Type Parameter: connectionType.
	 */
	public static final String RT_PARAM_CONNECTION_TYPE = "connectionType";

	/**
	 * Resource Type Parameter: initialization.
	 */
	public static final String RT_PARAM_INITIALIZATION = "initialization";

	/**
	 * Resource Type Parameter for the initialization strategy class name.
	 */
	public static final String RT_PARAM_INITIALIZATION_STRATEGY = "strategyClass";

	/**
	 * Resource Type Parameter for the initialization parameters.
	 */
	public static final String RT_PARAM_INITIALIZATION_PARAMETERS = "init-params";

	/**
	 * Resource Type Parameter for a single initialization parameter.
	 */
	public static final String RT_PARAM_INITIALIZATION_PARAMETER = "parameter";

	/**
	 * Resource Type Parameter for the key of a single initialization parameter.
	 */
	public static final String RT_PARAM_INITIALIZATION_PARAMETER_KEY = "key";

	/**
	 * Resource Type Parameter for the value of a single initialization parameter.
	 */
	public static final String RT_PARAM_INITIALIZATION_PARAMETER_VALUE = "value";

	/**
	 * Resource Type Parameter: heartbeat.
	 */
	public static final String RT_PARAM_HEARTBEAT = "heartbeat";

	/**
	 * Resource Type Parameter for the HeartBeat Connection Type.
	 */
	public static final String RT_PARAM_HEARTBEAT_CONNECTION_TYPE = "connectionType";

	/**
	 * Resource Type Parameter for the HeartBeat Strategy Class Name.
	 */
	public static final String RT_PARAM_HEARTBEAT_STRATEGY = "strategyClass";

	/**
	 * Resource Type Parameter for the HeartBeat Parameters.
	 */
	public static final String RT_PARAM_HEARTBEAT_PARAMETERS = "init-params";

	/**
	 * Resource Type Parameter for a single HeartBeat Parameter.
	 */
	public static final String RT_PARAM_HEARTBEAT_PARAMETER = "parameter";

	/**
	 * Resource Type Parameter for the key of a single HeartBeat Parameter.
	 */
	public static final String RT_PARAM_HEARTBEAT_PARAMETER_KEY = "key";

	/**
	 * Resource Type Parameter for the value of a single HeartBeat Parameter.
	 */
	public static final String RT_PARAM_HEARTBEAT_PARAMETER_VALUE = "value";

	// ========================================================================
	// ===================== RESOURCE GROUP EXTENSION POINT PARAMETERS
	// ========================================================================

	/**
	 * Resource Group Parameter: systemId (of the parent Resource Type).
	 */
	public static final String RG_PARAM_SYSTEM_ID = "systemId";

	/**
	 * Resource Group Parameter: name.
	 */
	public static final String RG_PARAM_NAME = "name";

	/**
	 * Resource Group Parameter: description.
	 */
	public static final String RG_PARAM_DESCRIPTION = "description";

	/**
	 * Resource Group Parameter: functionalType.
	 */
	public static final String RG_PARAM_FUNCTIONAL_TYPE = "functionalType";

	/**
	 * Resource Group Parameter: accessLevel (or Protection Key).
	 */
	public static final String RG_PARAM_PROTECTION_KEY = "accessLevel";

	/**
	 * Resource Group Parameter: isInternallyAcquired (boolean value).
	 */
	public static final String RG_PARAM_INTERNALLY_ACQUIRED = "isInternallyAcquired";

	/**
	 * Resource Group Parameter for the Allocation Strategy class name.
	 */
	public static final String RG_PARAM_ALLOCATION_STRATEGY = "allocationStrategyClass";

	/**
	 * Resource Group Parameter: imagePath (relative to the plug-in root).
	 */
	public static final String RG_PARAM_IMAGE_PATH = "imagePath";
	
	public static final String XML_EXTENSION = ".xml";
	
	public static final String GPD_EXTENSION = ".gpd";
	
	public static final String JPDL_EXTENSION = ".jpdl";
}
