package com.tandbergtv.watchpoint.studio.ui.editor;
/*
 * This class will register the actions for the Nodedefinition Editor  
 * based on the type of node(SINGLE/SUPERSTATE)
 */
import java.util.ArrayList;
import java.util.List;

import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.gef.ui.actions.PrintAction;
import org.eclipse.gef.ui.actions.RedoAction;
import org.eclipse.gef.ui.actions.SaveAction;
import org.eclipse.gef.ui.actions.StackAction;
import org.eclipse.gef.ui.actions.UndoAction;
import org.eclipse.gef.ui.actions.UpdateAction;
import org.eclipse.gef.ui.actions.WorkbenchPartAction;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchPart;
import org.jbpm.gd.common.notation.RootContainer;

import com.tandbergtv.watchpoint.studio.dto.NodeDefinitionType;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;


public class NodeDefinitionActionRegistry extends org.eclipse.gef.ui.actions.ActionRegistry {
	
	private NodeDefinitionEditor editorPart;
	
	private List<String> editPartActionIds;
	private List<String> stackActionIds;
	private List<String> editorActionIds;
	
	public NodeDefinitionActionRegistry(NodeDefinitionEditor editorPart) {
		initEditorPart(editorPart);
		initActionLists();
		initActions();
	}
	
	private void initEditorPart(NodeDefinitionEditor part) {
		this.editorPart = part;
	}
	
	private void initActionLists() {
		editPartActionIds = new ArrayList<String>();
		stackActionIds = new ArrayList<String>();
		editorActionIds = new ArrayList<String>();		
	}

	private void initActions() {
		addStackAction(new UndoAction(editorPart));
		addStackAction(new RedoAction(editorPart));
		addDeleteAction();
		addEditPartAction(new SaveAction(editorPart));
		registerAction(new PrintAction(editorPart));
	}
	private void addDeleteAction(){
		RootContainer rootContainer = editorPart.getRootContainer();
		NodeDefinition nodeDefinition = (NodeDefinition)rootContainer.getSemanticElement();
		NodeDefinitionType nodeType = nodeDefinition.getNodeType();
		if(nodeType!=NodeDefinitionType.MessageNode)
			addEditPartAction(new DeleteAction((IWorkbenchPart)editorPart));
	}
	private void addEditPartAction(WorkbenchPartAction action) {
		registerAction(action);
		editPartActionIds.add(action.getId());
	}
	
	private void addStackAction(StackAction action) {
		registerAction(action);
		
		stackActionIds.add(action.getId());
	}
	
	private void updateActions(List<String> actionIds) {
		for(String actionId: actionIds) {
			IAction action = getAction(actionId);
			if (null != action && action instanceof UpdateAction)
				((UpdateAction)action).update();
		}
	}
	
	public void updateStackActions() {
		updateActions(stackActionIds);
	}
	
	public void updateEditPartActions() {
		updateActions(editPartActionIds);
	}
	
	public void updateEditorActions() {
		updateActions(editorActionIds);
	}
	
}
