/*
 * Created on Oct 17, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.ui.editor.input;

import java.util.EventObject;

/**
 * Event that indicates that a WatchPointEditorInput has been updated.
 * 
 * @author Vijay Silva
 */
public class InputChangedEvent extends EventObject
{
	/* The Serialization Version Number */
	private static final long serialVersionUID = 3975206673787754641L;

	/**
	 * @param source
	 *            The WatchPointEditorInput that is the Source of the Event
	 */
	public InputChangedEvent(IWatchPointEditorInput source)
	{
		super(source);
	}

	/**
	 * @see java.util.EventObject#getSource()
	 */
	@Override
	public IWatchPointEditorInput getSource()
	{
		return (IWatchPointEditorInput) super.getSource();
	}
}
