package com.tandbergtv.watchpoint.studio.ui.properties;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

import org.eclipse.core.resources.IProject;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

import com.tandbergtv.watchpoint.studio.ui.model.DataCollectionManager;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;

public class RollbackNodeDefinitionTypeSectionComposite extends NodeDefinitionVariablesSectionComposite {

    private CCombo nodeDefinitionTypeCombo;

    public RollbackNodeDefinitionTypeSectionComposite(Composite parent, TabbedPropertySheetWidgetFactory widgetFactory, IStructuredContentProvider contentProvider) {
        super(parent, widgetFactory, contentProvider);
    }

    @Override
    protected void createComponents() {
        createComposite();
        createCombo();
        createTable();
        createTableViewer();
    }

    private void createCombo() {
        messageLabel = widgetFactory.createLabel(composite, "Type");
        FormData formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(0, 0);
        messageLabel.setLayoutData(formData);

        nodeDefinitionTypeCombo = widgetFactory.createCCombo(composite, SWT.DROP_DOWN | SWT.READ_ONLY);
        formData = new FormData();
        formData.top = new FormAttachment(0, 0);
        formData.left = new FormAttachment(messageLabel, 0, SWT.RIGHT);
        nodeDefinitionTypeCombo.setLayoutData(formData);

        nodeDefinitionTypeCombo.addModifyListener(new ModifyListener() {
            @Override
            public void modifyText(ModifyEvent e) {
                if (nodeDefinitionTypeCombo.getText().equals("") ) {
                    return;
                }
                String uid = (String) nodeDefinitionTypeCombo.getData(nodeDefinitionTypeCombo.getText());
                NodeDefinition nodeDefinition = DataCollectionManager.getInstance().getReader().getNewMessageNode(uid);
                ((NodeDefinition)tableViewer.getInput()).setRollbackNode(nodeDefinition);

                tableViewer.refresh();
            }
        });

        //FIXME Filter by resource type
        Collection<String> uids = DataCollectionManager.getInstance().getReader().getMessageNodeUrlByUidMap().keySet();
        List<String> items = new ArrayList<String>();
        for (String uid : uids) {
            NodeDefinition nodeDefinition = DataCollectionManager.getInstance().getReader().getSampleMessageNodeByUid(uid);
            nodeDefinitionTypeCombo.setData(nodeDefinition.getName(), uid);
            items.add(nodeDefinition.getName());
        }
        Collections.sort(items);

        nodeDefinitionTypeCombo.setItems(items.toArray(new String[0]));
    }

    @Override
    public void setInput(NodeDefinition nodeDefinition, IProject project) {
        super.setInput(nodeDefinition, project);
        selectCurrentComboOption(nodeDefinition);
    }

    private void selectCurrentComboOption(NodeDefinition nodeDefinition) {
        int currentSelected = -1;
        String option = null;
        for (int i = 0; i < nodeDefinitionTypeCombo.getItems().length; i++) {
            option = nodeDefinitionTypeCombo.getItems()[i];
            if (nodeDefinitionTypeCombo.getData(option).equals(nodeDefinition.getRollbackUid())) {
                currentSelected = i;
                break;
            }
        }

        if (currentSelected >= 0) {
            nodeDefinitionTypeCombo.select(currentSelected);
        }
    }
}