/**
 * 
 */
package com.tandbergtv.watchpoint.studio.ui.properties;

import org.apache.log4j.Logger;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.jbpm.gd.common.properties.AbstractPropertySection;

import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.util.Utility;

public class SuperStateVariablesSection extends AbstractPropertySection {
    private Logger logger = Logger.getLogger(SuperStateVariablesSection.class);
    private SuperStateVariablesSectionComposite composite;

    public void createControls(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        super.createControls(parent, aTabbedPropertySheetPage);
        composite = new SuperStateVariablesSectionComposite(parent, getWidgetFactory());
        logger.debug("createControls");
    }

    /**
     * @see org.jbpm.gd.common.properties.AbstractPropertySection#setInput(org.eclipse.ui.IWorkbenchPart,
     *      org.eclipse.jface.viewers.ISelection)
     */
    public void setInput(IWorkbenchPart part, ISelection selection) {
        logger.debug("setInput");
        super.setInput(part, selection);
        if (composite != null) {
            composite.setInput((NodeDefinition) Utility.getSemanticElement(selection));
        }
    }

    public boolean shouldUseExtraSpace() {
        return true;
    }
}