/**
 * RemoveMessageCommand.java
 * Created Apr 20, 2010
 */
package com.tandbergtv.watchpoint.studio.ui.sync.resource;

import com.tandbergtv.watchpoint.studio.dto.Message;
import com.tandbergtv.watchpoint.studio.ui.sync.IDiff;
import com.tandbergtv.watchpoint.studio.ui.sync.command.AbstractDiffCommand;
import com.tandbergtv.watchpoint.studio.ui.sync.util.ISynchronizationContext;

/**
 * Deletes a message
 * 
 * @author Sahil Verma
 */
public class RemoveMessageCommand extends AbstractDiffCommand {

	private Message model;
	
	/**
	 * Creates a command
	 * 
	 * @param name
	 * @param diff
	 * @param context
	 */
	public RemoveMessageCommand(String name, IDiff diff, ISynchronizationContext context) {
		super(name, diff, context);
		this.model = (Message) diff.getModel();
	}

	/**
	 * {@inheritDoc}
	 */
	public void execute() {
		model.getResourceType().removeMessage(model);
		context.deleteMessage(model);
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public String toString() {
		return model + " " + diff.getKind();
	}
}
