package com.tandbergtv.watchpoint.studio.ui.view;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ResourceTypeMessageRenameDialog extends ResourceTypeMessageReferencesTreeBase {
	private Text nameField;
	private Label nameLabel;
	private boolean OKButtonenabled = false;
	private Button OKButton;
	private Button cancelButton;
	private Button previewButton;
	
	public ResourceTypeMessageRenameDialog (Shell parentShell) {
		super(parentShell);
		setShellStyle(getShellStyle() | SWT.RESIZE | SWT.MAX);
	}

	protected Control createDialogArea(Composite parent) {
		Composite container = (Composite) super.createDialogArea(parent);
		GridLayout gridLayout = new GridLayout();
		container.setLayout(gridLayout); 
		gridLayout.numColumns = 2;
		
		/* Create name label */
		nameLabel = new Label(container, SWT.NONE);
		nameLabel.setLayoutData(new GridData(GridData.END, GridData.CENTER, false, false));
		nameLabel.setText("New Name:");
		/* Create name field */
		nameField = new Text(container, SWT.BORDER);
		nameField.setLayoutData(new GridData(GridData.FILL, GridData.CENTER, true, false));
		nameField.setText( (messageName != null) ? messageName : "" );
		nameField.selectAll();
		nameField.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				handleNameFieldModification(e);
			}
		});
		
		/* Creates references tree UI widgets */
		super.createControls(container);
		
		return container;
	}
	
	private void handleNameFieldModification(ModifyEvent e){
		if ( e.widget == nameField ){
			if(nameField.getText().equals(messageName)){
				setOKButtonEnabled(false);
			} else {
				setOKButtonEnabled(true);
			}
		}
	}
	
	protected void createButtonsForButtonBar(Composite parent) {	 
		 // Create Preview button
	    previewButton = createButton(parent, 2, "Preview", false);
	    previewButton.setEnabled(true);
	    // Add a SelectionListener
	    previewButton.addSelectionListener(new SelectionAdapter() {
	      public void widgetSelected(SelectionEvent e) {
	    	  showReferencesTree();
	      }
	    });
	    
	    // Create OK button
	    OKButton = createButton(parent, OK, "OK", true);
	    OKButton.setEnabled(OKButtonenabled);
	    // Add a SelectionListener
	    OKButton.addSelectionListener(new SelectionAdapter() {
	      public void widgetSelected(SelectionEvent e) {
	    	  setReturnCode(OK);
		        close();
	      }
	    });
	    
	    // Create Cancel button
	    cancelButton = createButton(parent, CANCEL, "Cancel", false);
	    // Add a SelectionListener
	    cancelButton.addSelectionListener(new SelectionAdapter() {
	      public void widgetSelected(SelectionEvent e) {
	        setReturnCode(CANCEL);
	        close();
	      }
	    });
	}
	
	protected void configureShell(Shell newshell) {
		  super.configureShell(newshell);
		  newshell.setSize(470, 210);
		  newshell.setText("Rename Message Dialog");
	}
	  
	@Override
	protected void okPressed()
	{
		this.messageName = this.nameField.getText().trim();
		updateReferences = updateReferencesButton.getSelection();
		fillAffectedMessages();
		super.okPressed();
	}	  
	
	public Point getInitialSize() {
		  return new Point(300,350);
	}
	
	public void setOKButtonEnabled(boolean enabled) {
		OKButtonenabled = enabled;
		OKButton.setEnabled(OKButtonenabled);
	}
	
}
