package com.tandbergtv.watchpoint.studio.ui.wizard.imports;

import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

import com.tandbergtv.watchpoint.studio.dto.IWatchPointDTO;
import com.tandbergtv.watchpoint.studio.dto.ResourceGroup;
import com.tandbergtv.watchpoint.studio.dto.ResourceType;
import com.tandbergtv.watchpoint.studio.dto.WorkflowTemplateDTO;
import com.tandbergtv.watchpoint.studio.ui.WatchPointStudioPlugin;
import com.tandbergtv.watchpoint.studio.ui.wizard.resource.ResourceGroupDataProvider;
import com.tandbergtv.watchpoint.studio.ui.wizard.resource.ResourceTypeDataProvider;
import com.tandbergtv.watchpoint.studio.ui.wizard.template.TemplateDataProvider;

/**
 * Import wizard
 * 
 * @author Sahil Verma
 */
public abstract class ImportWizard extends Wizard implements IImportWizard {

	protected ImportWizardFirstPage page1;
	
	protected ImportWizardListPage page2;
	
	protected ImportWizardSummaryPage page3;

	protected IStructuredSelection selection;
	
	protected Class<? extends IWatchPointDTO> clazz;
	
	private static final String NAME = "PluginImport";
	
	/**
	 * Default ctor 
	 */
	public ImportWizard(Class<? extends IWatchPointDTO> clazz, String title) {
		IDialogSettings settings = WatchPointStudioPlugin.getDefault().getDialogSettings();
		setDialogSettings(getSettings(settings, NAME));
		setWindowTitle(title);
		this.clazz = clazz;
	}

	private IDialogSettings getSettings(IDialogSettings master, String name) {
		IDialogSettings settings = master.getSection(name);
		
		if (settings == null)
			settings = master.addNewSection(name);
		
		return settings;
	}
	
	@Override
	public boolean performFinish() {
		page1.saveSettings(getDialogSettings());
		page2.saveSettings(getDialogSettings());
		page3.saveSettings(getDialogSettings());
		
		Importer importer = Importers.getImporter(clazz);
		ImportOperation job = 
			new ImportOperation("Importing selected items", page3.getDiffModel(), importer);
		
		job.setUser(true);
		job.schedule();
		
		return true;
	}

	public void init(IWorkbench workbench, IStructuredSelection selection) {
		this.selection = selection;
	}

	/**
	 * {@inheritDoc}
	 */
	@Override
	public void addPages() {
		setNeedsProgressMonitor(true);
		super.addPages();
		
		page1 = new ImportWizardFirstPage("Choose Import Directory", this.clazz);
		
		/* FIXME Register providers using the extension mechanism. Also, provide a way to choose
		 * the types of import location - local repository, HTTP repository, database etc */
		page1.addProvider(ResourceType.class, new ResourceTypeDataProvider());
		page1.addProvider(ResourceGroup.class, new ResourceGroupDataProvider());
		page1.addProvider(WorkflowTemplateDTO.class, new TemplateDataProvider());
		
		addPage(page1);
		
		page2 = new ImportWizardListPage("Selection", page1, this.selection);
		
		addPage(page2);
		
		page3 = new ImportWizardSummaryPage("Name", page2, clazz);
		
		addPage(page3);
	}
}
