package com.tandbergtv.watchpoint.studio.ui.xml;

import java.beans.PropertyChangeEvent;

import org.jbpm.gd.common.model.SemanticElement;
import org.jbpm.gd.common.xml.XmlAdapter;

import com.tandbergtv.watchpoint.studio.ui.model.ResourceGroup;

/**
 * The Adaptor class for a resource group.
 * 
 * @author Imran Naqvi
 * 
 */
public class ResourceGroupDomAdapter extends XmlAdapter {

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jbpm.gd.common.xml.XmlAdapter#initialize()
	 */
	@Override
	protected void initialize() {
		super.initialize();
		if (getSemanticElement() != null) {
			ResourceGroup resourceGroup = (ResourceGroup) getSemanticElement();
			setAttribute("name", resourceGroup.getName());
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jbpm.gd.common.xml.XmlAdapter#doModelAdd(org.jbpm.gd.common.xml.XmlAdapter)
	 */
	@Override
	protected void doModelAdd(XmlAdapter child) {
		// TODO Auto-generated method stub

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jbpm.gd.common.xml.XmlAdapter#doModelRemove(org.jbpm.gd.common.xml.XmlAdapter)
	 */
	@Override
	protected void doModelRemove(XmlAdapter child) {
		// TODO Auto-generated method stub

	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jbpm.gd.common.xml.XmlAdapter#doModelUpdate(java.lang.String, java.lang.String)
	 */
	@Override
	protected void doModelUpdate(String name, String newValue) {
		ResourceGroup resourceGroup = (ResourceGroup) getSemanticElement();
		if ("name".equals(name)) {
			resourceGroup.setName(newValue);
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see java.beans.PropertyChangeListener#propertyChange(java.beans.PropertyChangeEvent)
	 */
	public void propertyChange(PropertyChangeEvent evt) {
		if ("name".equals(evt.getPropertyName())) {
			setAttribute("name", (String) evt.getNewValue());
		}
	}

	/*
	 * (non-Javadoc)
	 * 
	 * @see org.jbpm.gd.common.xml.XmlAdapter#initialize(org.jbpm.gd.common.model.SemanticElement)
	 */
	@Override
	public void initialize(SemanticElement jpdlElement) {
		super.initialize(jpdlElement);
		ResourceGroup resourceGroup = (ResourceGroup) jpdlElement;
		resourceGroup.setName(getAttribute("name"));
		resourceGroup.addPropertyChangeListener(this);
	}

}
