package com.tandbergtv.watchpoint.studio.util;

/**
 * @author Raj Prakash
 * 
 * Marshaller to marshall/unmarshall from 
 * Timer Expression to String representation and vice-versa.
 *
 */
public class TimerExpressionMarshaller {
	public static String marshall(TimerExpression timerExpr) {
		return timerExpr.getOperand1() + timerExpr.getOperator() + timerExpr.getOperand2();
	}
	
	public static TimerExpression unmarshall(String expression) {
		if(expression == null)
			return new TimerExpression();
		
		int additionOperatorIndex = expression.indexOf(TimerExpression.ADDITION_OPERATOR);
		if(additionOperatorIndex != -1) {
			return new TimerExpression(expression.substring(0, additionOperatorIndex),
					TimerExpression.ADDITION_OPERATOR, expression.substring(additionOperatorIndex +
					TimerExpression.ADDITION_OPERATOR.length()));
		}
		else {
			int multiplicationOperatorIndex = expression.indexOf(TimerExpression.MULTIPLICATION_OPERATOR);
			if(multiplicationOperatorIndex != -1) {
				return new TimerExpression(expression.substring(0, multiplicationOperatorIndex),
						TimerExpression.MULTIPLICATION_OPERATOR, expression.substring(multiplicationOperatorIndex +
						TimerExpression.MULTIPLICATION_OPERATOR.length()));
			}
			else {
				return new TimerExpression(expression, null, null);
			}
		}
	}
}
