/**
 * 
 */
package com.tandbergtv.watchpoint.studio.validation.rules.expression;

import java.util.ArrayList;
import java.util.List;

import com.tandbergtv.watchpoint.studio.util.DueDateExprValidator;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationRule;
import com.tandbergtv.watchpoint.studio.validation.model.DueDateExpression;

/**
 * This class validates the Timer Expression Rules
 * @author DReddy
 *
 */
public class DueDateValidateRule extends ValidationRule<DueDateExpression> {

	/* (non-Javadoc)
	 * @see com.tandbergtv.watchpoint.studio.validation.IValidationRule#validateRule(java.lang.Object)
	 */
	public List<ValidationMessage> validateRule(DueDateExpression target) {
		List<ValidationMessage> messages= null;
		if(target == null)
			return messages;
		ValidationMessage valMsg = (new DueDateExprValidator(target)).validate();
		if(valMsg!=null){
			messages = new ArrayList<ValidationMessage>();
			messages.add(valMsg);
		}
		return messages;
	}

}
