/*
 * Created on Nov 8, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement;

import static com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode.NODE_NAME_BLANK;
import static com.tandbergtv.watchpoint.studio.validation.ValidationMessageCode.NODE_NAME_INVALID;

import java.util.ArrayList;
import java.util.List;

import org.jbpm.gd.jpdl.model.NodeElement;

import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.ValidationRule;
import com.tandbergtv.watchpoint.studio.validation.impl.ValidationMessageAdder;

/**
 * Validation Rule that ensures that the Node Element name is valid.
 * 
 * @author Vijay Silva
 */
public class NodeNameRule extends ValidationRule<NodeElement> {
	/**
	 * Validate the Node Element name. Ensures that the Node Element name is legit.
	 * 
	 * @param target
	 *            The Node Element to validate
	 * 
	 * @return The list of validation rules
	 * 
	 * @see com.tandbergtv.watchpoint.studio.validation.IValidationRule#validateRule(java.lang.Object)
	 */
	public List<ValidationMessage> validateRule(NodeElement target) {
		List<ValidationMessage> messages = new ArrayList<ValidationMessage>();

		String name = target.getName();
		
		if (name == null || name.trim().length() == 0)
            ValidationMessageAdder.getInstance().addValidationMessage(messages, target, NODE_NAME_BLANK);
        else if (name.contains("/"))
            ValidationMessageAdder.getInstance().addValidationMessage(messages, target, NODE_NAME_INVALID);

		return messages;
	}
}
