/*
 * Created on Nov 13, 2007
 * 
 * (C) Copyright TANDBERG Television Ltd.
 */

package com.tandbergtv.watchpoint.studio.validation.rules.nodeelement;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

import org.jbpm.gd.jpdl.model.NodeElement;
import org.jbpm.gd.jpdl.model.Variable;

import com.tandbergtv.watchpoint.studio.ui.model.IWPVariableContainer;
import com.tandbergtv.watchpoint.studio.ui.model.NodeDefinition;
import com.tandbergtv.watchpoint.studio.ui.model.WPVariable;
import com.tandbergtv.watchpoint.studio.ui.model.WorkflowTemplate;
import com.tandbergtv.watchpoint.studio.validation.ValidationMessage;
import com.tandbergtv.watchpoint.studio.validation.model.ContainerNode;
import com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.nodedefinition.IRequiredVariableFinder;
import com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.nodedefinition.SuperStateRequiredVariableFinder;
import com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.nodedefinition.TemplateRequiredVariableFinder;

/**
 * Validates the Variable Mapping for Node Elements that implement IWPVariableContainer.
 * 
 * @author Vijay Silva
 */
public class VariableContainerVariableMappingRule extends NodeVariablesMappingRule {
	/**
	 * @see com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.NodeVariablesMappingRule#getVariables(org.jbpm.gd.jpdl.model.NodeElement)
	 */
	@Override
	protected List<WPVariable> getVariables(NodeElement node) {
		List<WPVariable> variables = new ArrayList<WPVariable>();

		if (node instanceof IWPVariableContainer) {
			IWPVariableContainer variableContainer = (IWPVariableContainer) node;
			List<WPVariable> nodeVariables = variableContainer.getVariables();
			if (nodeVariables != null)
				variables.addAll(nodeVariables);
		}

		return variables;
	}

	/**
	 * @see com.tandbergtv.watchpoint.studio.validation.rules.nodeelement.NodeVariablesMappingRule#validateMissingMapping(com.tandbergtv.watchpoint.studio.validation.model.ContainerNode,
	 *      java.util.Map, java.util.List)
	 */
	@Override
	protected void validateMissingMapping(ContainerNode node, Map<Variable, WPVariable> mapping, 
		List<ValidationMessage> messages) {
		NodeElement containedNode = node.getNode();
		
		if (containedNode instanceof NodeDefinition) {
			Set<String> names = this.getRequiredVariableNames(node);
			Map<Variable, WPVariable> filteredMapping = new HashMap<Variable, WPVariable>();

			for (Variable variable : mapping.keySet()) {
				if (names != null && names.contains(variable.getMappedName()))
					filteredMapping.put(variable, mapping.get(variable));
			}

			mapping = filteredMapping;
		}

		super.validateMissingMapping(node, mapping, messages);
	}

	/*
	 * Gets the set of all variable names in the Node Definition Node that must be mapped.
	 */
	private Set<String> getRequiredVariableNames(ContainerNode node) {
		IRequiredVariableFinder variableFinder = null;
		Set<String> variableNames = null;

		if (node.getContainer() instanceof WorkflowTemplate)
			variableFinder = new TemplateRequiredVariableFinder();
		else if (node.getContainer() instanceof NodeDefinition)
			variableFinder = new SuperStateRequiredVariableFinder();

		if (variableFinder != null)
			variableNames = variableFinder.getRequiredVariableNames((NodeDefinition) node.getNode());

		return variableNames;
	}
}
